﻿//////////////////////////////////////////////
// ResourceTask.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Resource ;
	class ResourceSaveLoadCallback ;
	class ResourceSetLoadQuery ;
	class System ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

// nkTasks
#include <NilkinsTasks/Scheduler/SchedulerTask.h>

// Standards
#include <string>

/// Class ------------------------------------

namespace nkGraphics
{
	enum class RESOURCE_TASK_TYPE
	{
		UNKNOWN = 0,
		LOAD_CAMERA,
		LOAD_BLEND_STATE,
		LOAD_DEPTH_STENCIL_STATE,
		LOAD_RASTER_STATE,
		LOAD_SAMPLER,
		LOAD_TEXTURE,
		LOAD_BUFFER,
		LOAD_SHADER,
		LOAD_PROGRAM,
		LOAD_MESH,
		LOAD_COMPOSITOR,
		LOAD_NODE,
		LOAD_RESOURCE_SET
	} ;

	class ResourceTask final : public nkTasks::SchedulerTask
	{
		public :
	
			// Constructor, destructor
			ResourceTask (System* system) noexcept ;
			virtual ~ResourceTask () ;

			// Getters
			System* getSystem () const ;

			// Setters
			void setTaskType (RESOURCE_TASK_TYPE value) ;
			void setDeclPath (nkMemory::StringView value) ;
			void setLoadQuery (ResourceSetLoadQuery* value) ;
			void setDefaultCompoName (nkMemory::StringView value) ;
			void setCallback (ResourceSaveLoadCallback* value) ;

			// Implementation
			virtual void onAsyncWork () override ;
			virtual void onSync () override ;

		private :

			// Attributs
			// Type de task à faire
			RESOURCE_TASK_TYPE _type ;
			// Le path de la déclaration concernée
			nkMemory::String _declPath ;

			System* _system ;

			// Données supplémentaires pour les réponses
			nkMemory::BufferCast<nkMemory::String> _messages ;
			nkMemory::BufferCast<void*> _successResources ;

			// Cas de chargement de resource set
			nkMemory::BufferCast<std::pair<RESOURCE_TASK_TYPE, std::string>> _resourceSetResult ;
			ResourceSetLoadQuery* _loadQuery ;

			// Compositors peuvent avoir le default à mettre
			nkMemory::String _defaultCompoName ;

			// Callback client
			ResourceSaveLoadCallback* _callback ;

			// Status
			bool _failed ;
	} ;
}